/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.ftb.log.LogLevel;
import net.ftb.log.LogSource;
import net.ftb.log.LogType;
import net.ftb.log.Logger;

public class LogEntry {
    private String message = "";
    public LogLevel level = LogLevel.UNKNOWN;
    public LogSource source = LogSource.LAUNCHER;
    private Throwable cause;
    private String location;
    private final String dateString;
    private final Map<LogType, String> messageCache = new HashMap<LogType, String>();
    private static final String dateFormatString = "HH:mm:ss";

    public LogEntry() {
        Date date = new Date();
        this.dateString = new SimpleDateFormat(dateFormatString).format(date);
        this.location = LogEntry.getLocation(this.cause);
    }

    public LogEntry message(String message) {
        this.message = message;
        if (this.level == LogLevel.UNKNOWN) {
            this.level = (message = message.toLowerCase()).contains("[severe]") || message.contains("[stderr]") || message.contains("[error]") ? LogLevel.ERROR : (message.contains("[info]") ? LogLevel.INFO : (message.contains("[warning]") || message.contains("[warn]") ? LogLevel.WARN : (message.contains("error") || message.contains("severe") ? LogLevel.ERROR : (message.contains("warn") ? LogLevel.WARN : LogLevel.INFO))));
        }
        return this;
    }

    public LogEntry level(LogLevel level) {
        this.level = level;
        return this;
    }

    public LogEntry source(LogSource source) {
        this.source = source;
        return this;
    }

    public LogEntry cause(Throwable cause) {
        if (cause != this.cause) {
            this.location = LogEntry.getLocation(cause);
        }
        this.cause = cause;
        return this;
    }

    public LogEntry copyInformation(LogEntry entry) {
        this.message = entry.message;
        this.source = entry.source;
        this.level = entry.level;
        return this;
    }

    public String toString() {
        return this.toString(LogType.MINIMAL);
    }

    public String toString(LogType type) {
        if (this.messageCache.containsKey((Object)type)) {
            return this.messageCache.get((Object)type);
        }
        StringBuilder entryMessage = new StringBuilder();
        if (this.source != LogSource.EXTERNAL) {
            if (type.includes(LogType.EXTENDED)) {
                entryMessage.append("[").append(this.dateString).append("] ");
            }
            if (type.includes(LogType.EXTENDED)) {
                entryMessage.append("[").append((Object)this.level).append("] ");
            }
            if (type.includes(LogType.DEBUG)) {
                entryMessage.append("in ").append((Object)this.source).append(" ");
            }
            if (this.location != null && type.includes(LogType.EXTENDED)) {
                entryMessage.append(this.location).append(": ");
            }
        }
        entryMessage.append(this.message);
        if (this.cause != null) {
            entryMessage.append(": ").append(this.cause.toString());
            if (type.includes(LogType.EXTENDED)) {
                for (StackTraceElement stackTraceElement : this.cause.getStackTrace()) {
                    entryMessage.append("\n").append(stackTraceElement.toString());
                }
            }
        }
        String message = entryMessage.toString();
        this.messageCache.put(type, message);
        return message;
    }

    private static String getLocation(Throwable t) {
        String location = "";
        if (t != null) {
            location = location + LogEntry.getLocation(t.getStackTrace()) + "->";
        }
        location = location + LogEntry.getLocation(new Throwable().getStackTrace());
        return location;
    }

    private static String getLocation(StackTraceElement[] stackTraceElements) {
        for (StackTraceElement ste : stackTraceElements) {
            if (ste.getClassName().equals(Logger.class.getName()) || ste.getClassName().equals(LogEntry.class.getName())) continue;
            return ste.getClassName().substring(ste.getClassName().lastIndexOf(46) + 1) + "." + ste.getMethodName() + ":" + ste.getLineNumber();
        }
        return "unknown location";
    }
}

